/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.via6522;

import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.vectrex.PersistentSection;
import frc.emul.via6522.I6522ExternalLines;
import frc.emul.via6522.I6522ExternalListener;
import frc.emul.via6522.I6522InternalLines;
import frc.emul.via6522.I6522InternalListener;
import java.util.ArrayList;
import java.util.List;

public class Via6522Lines
implements I6522ExternalLines,
I6522InternalLines,
IPersistentObject {
    private final transient List<I6522InternalListener> intListeners = new ArrayList<I6522InternalListener>();
    private final transient List<I6522ExternalListener> extListeners = new ArrayList<I6522ExternalListener>();
    private int viaInA;
    private int viaOutA;
    private int viaInB;
    private int viaOutB;
    private int DDRA;
    private int DDRB;
    private boolean viaOutIRQ;
    private boolean viaOutCA2;
    private boolean viaOutCB1;
    private boolean viaOutCB2;
    private boolean viaInCA1;
    private boolean viaInCA2;
    private boolean viaInCB1;
    private boolean viaInCB2;

    public int read_PA() {
        return this.viaOutA;
    }

    public int read_PB() {
        return this.viaOutB;
    }

    public boolean read_CA2() {
        return this.viaOutCA2;
    }

    public boolean read_CB1() {
        return this.viaOutCB1;
    }

    public boolean read_CB2() {
        return this.viaOutCB2;
    }

    public boolean read_IRQ() {
        return this.viaOutIRQ;
    }

    public void write_PA(int n) {
        if (n != this.viaInA) {
            this.viaInA = n;
            this.fireExt(0, n);
        }
    }

    public void write_PB(int n) {
        if (n != this.viaInB) {
            this.viaInB = n;
            this.fireExt(1, n);
        }
    }

    public void write_CA1(boolean bl) {
        if (bl != this.viaInCA1) {
            this.viaInCA1 = bl;
            this.fireExt(0, bl);
        }
    }

    public void write_CA2(boolean bl) {
        if (bl != this.viaInCA2) {
            this.viaInCA2 = bl;
            this.fireExt(1, bl);
        }
    }

    public void write_CB1(boolean bl) {
        if (bl != this.viaInCB1) {
            this.viaInCB1 = bl;
            this.fireExt(2, bl);
        }
    }

    public void write_CB2(boolean bl) {
        if (bl != this.viaInCB2) {
            this.viaInCB2 = bl;
            this.fireExt(3, bl);
        }
    }

    public void add6522Listener(I6522ExternalListener i6522ExternalListener) {
        this.extListeners.add(i6522ExternalListener);
    }

    public void remove6522Listener(I6522ExternalListener i6522ExternalListener) {
        this.extListeners.remove(i6522ExternalListener);
    }

    public int via_read_PA() {
        return this.viaInA;
    }

    public int via_read_PB() {
        return this.viaInB;
    }

    public boolean via_read_CA1() {
        return this.viaInCA1;
    }

    public boolean via_read_CA2() {
        return this.viaInCA2;
    }

    public boolean via_read_CB1() {
        return this.viaInCB1;
    }

    public boolean via_read_CB2() {
        return this.viaInCB2;
    }

    public void via_write_CB1(boolean bl) {
        if (bl != this.viaOutCB1) {
            this.viaOutCB1 = bl;
            this.fireInt(2, bl);
        }
    }

    public void via_write_CB2(boolean bl) {
        if (bl != this.viaOutCB2) {
            this.viaOutCB2 = bl;
            this.fireInt(3, bl);
        }
    }

    public void via_write_CA2(boolean bl) {
        if (bl != this.viaOutCA2) {
            this.viaOutCA2 = bl;
            this.fireInt(1, bl);
        }
    }

    public void via_write_IRQ(boolean bl) {
        if (bl != this.viaOutIRQ) {
            this.viaOutIRQ = bl;
            this.fireInt(4, bl);
        }
    }

    public void via_write_PA(int n, int n2) {
        this.viaInA = n;
        if (n != this.viaOutA || n2 != this.DDRA) {
            this.DDRA = n2;
            this.viaOutA = n;
            this.fireInt(0, n, n2);
        }
    }

    public void via_write_PB(int n, int n2) {
        if (n != this.viaOutB || n2 != this.DDRB) {
            this.DDRB = n2;
            this.viaOutB = n |= ~this.DDRB & 0xFF;
            this.fireInt(1, n, n2);
        }
        this.viaInB = n;
    }

    public void add6522Listener(I6522InternalListener i6522InternalListener) {
        this.intListeners.add(i6522InternalListener);
    }

    public void remove6522Listener(I6522InternalListener i6522InternalListener) {
        this.intListeners.remove(i6522InternalListener);
    }

    private final void fireExt(int n, int n2) {
        int n3 = this.intListeners.size();
        while (n3-- > 0) {
            this.intListeners.get(n3).externalPortWritten(n, n2);
        }
    }

    private final void fireExt(int n, boolean bl) {
        int n2 = this.intListeners.size();
        while (n2-- > 0) {
            this.intListeners.get(n2).externalLineWritten(n, bl);
        }
    }

    private final void fireInt(int n, int n2, int n3) {
        int n4 = this.extListeners.size();
        while (n4-- > 0) {
            this.extListeners.get(n4).internalPortWritten(n, n2, n3);
        }
    }

    private final void fireInt(int n, boolean bl) {
        int n2 = this.extListeners.size();
        while (n2-- > 0) {
            this.extListeners.get(n2).internalLineWritten(n, bl);
        }
    }

    public IPersistentSection getSection() {
        return PersistentSection.LINES;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.write16(this.viaInA);
        iPersistenceWriter.write16(this.viaOutA);
        iPersistenceWriter.write16(this.viaInB);
        iPersistenceWriter.write16(this.viaOutB);
        iPersistenceWriter.write16(this.DDRA);
        iPersistenceWriter.write16(this.DDRB);
        iPersistenceWriter.write(this.viaOutIRQ);
        iPersistenceWriter.write(this.viaOutCA2);
        iPersistenceWriter.write(this.viaOutCB1);
        iPersistenceWriter.write(this.viaOutCB2);
        iPersistenceWriter.write(this.viaInCA1);
        iPersistenceWriter.write(this.viaInCA2);
        iPersistenceWriter.write(this.viaInCB1);
        iPersistenceWriter.write(this.viaInCB2);
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        this.viaInA = iPersistenceReader.readS16();
        this.viaOutA = iPersistenceReader.readS16();
        this.viaInB = iPersistenceReader.readS16();
        this.viaOutB = iPersistenceReader.readS16();
        this.DDRA = iPersistenceReader.readS16();
        this.DDRB = iPersistenceReader.readS16();
        this.viaOutIRQ = iPersistenceReader.readBool();
        this.viaOutCA2 = iPersistenceReader.readBool();
        this.viaOutCB1 = iPersistenceReader.readBool();
        this.viaOutCB2 = iPersistenceReader.readBool();
        this.viaInCA1 = iPersistenceReader.readBool();
        this.viaInCA2 = iPersistenceReader.readBool();
        this.viaInCB1 = iPersistenceReader.readBool();
        this.viaInCB2 = iPersistenceReader.readBool();
    }
}

